//  Listing 11.4. Inicjowanie jednego obiektu za pomoc danych z innego obiektu

#include <iostream>
using namespace std;

class String 
{
char *str; 				// dynamicznie zapamitana tablica znakowa
int len;
  public:
String (int length=0); 			// konstruktor konwertujcy i domylny
String(const char*); 			// konstruktor konwertujcy
~String (); 				// przydziel dynamicznie pami
void operator += (const String&); 	// konkatenacja innego obiektu
void modify(const char*); 		// zmiana zawartoci tablicy znakowej
const char* show() const; 		// zwrot wskanika do tablicy
} ;

String::String(int length)
{ len = length;
str = new char[len+1];
if (str==NULL) exit(1);
str[0] = 0; } 				// pusty acuch o zerowej dugoci te jest OK

String::String(const char* s)
{ len = strlen(s); 			// pomiar dugoci tekstu wejciowego
str = new char[len+1]; 			// przydzia pamici na stercie
if (str==NULL) exit(1); 		// sprawd, czy si powiodo
strcpy(str,s); } 			// skopiuj wejciowy tekst na stert

String::~String()
 { delete str; } 			// zwrot pamici na stercie (a nie wskanika!)

void String::operator += (const String& s) 	// parametr referencyjny
{ len = strlen(str) + strlen(s.str); 		// cakowita dugo
char* p = new char[len + 1]; 			// przydziel wystarczajc ilo miejsca
if (p==NULL) exit(1); 				// sprawd, czy si powiodo
strcpy(p,str); 					// kopiuj pierwsz cz rezultatu
strcat(p,s.str); 				// dodaj drug cz rezultatu
delete str; 					// wany krok
str = p; } 					// teraz tymczasowy wskanik p moe znikn

const char* String::show() const 	// chro dane przed zmianami
 { return str; }

void String::modify(const char a[]) 	// bez zarzdzania pamici
{ strncpy(str,a,len-1); 		// ochrona przed przepenieniem
str[len-1] = 0; } 			// poprawne zakoczenie tekstu

int main()
{ 
cout << endl << endl;
String u("This is a test. ");
String v("Nothing can go wrong.");
cout << " u = " << u.show() << endl; 	// wynik jest OK
cout << " v = " << v.show() << endl; 	// wynik jest OK
u += v;       				// to odpowiada: u.operator+=(s);
cout << " u = " << u.show() << endl; 	// wynik jest OK
cout << " v = " << v.show() << endl; 	// OK - poprzez referencj
v.modify("Let us hope for the best."); 	// bez uszkodzenia pamici
{ String t = v; 			// inicjowanie
cout << " t = " << t.show() << endl; 	// wynik jest OK
t.modify("Nothing can go wrong."); 	// zmieniamy obydwa - t oraz v
cout << " t = " << t.show() << endl; 	// wynik jest OK
cout << " v = " << v.show() << endl; } 	// v take jest zmodyfikowany
cout << " v = " << v.show() << endl; 	// t znika, v pozbawiony pamici
return 0;
}
